#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include "engine.h"
#include "helper_functions.h"

PyCFunction* scriptsdll_disableenlisted(PyObject *self, PyObject *args)
{
	unsigned int team, position;

	if (!PyArg_ParseTuple(args, "II", &team, &position))
	{
		printf("\nError occured inside scriptsdll.disableenlisted.\n Bad argument(s)?\n");
        return NULL;
	}
	Disable_Enlisted(team, position);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_disablepreset(PyObject *self, PyObject *args)
{
	unsigned int team, type, position;

	if (!PyArg_ParseTuple(args, "III", &team, &type, &position))
	{
		printf("\nError occured inside scriptsdll.disablepreset.\n Bad argument(s)?\n");
        return NULL;
	}
	Disable_Preset(team, type, position);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_disableenlistedbyname(PyObject *self, PyObject *args)
{
	unsigned int team;
	const char* name;

	if (!PyArg_ParseTuple(args, "Is", &team, &name))
	{
		printf("\nError occured inside scriptsdll.disableenlistedbyname.\n Bad argument(s)?\n");
        return NULL;
	}
	Disable_Enlisted_By_Name(team, name);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_disablepresetbyname(PyObject *self, PyObject *args)
{
	unsigned int team;
	const char* name;

	if (!PyArg_ParseTuple(args, "Is", &team, &name))
	{
		printf("\nError occured inside scriptsdll.disablepresetbyname.\n Bad argument(s)?\n");
        return NULL;
	}
	Disable_Preset_By_Name(team, name);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_disableallgroundvehicles(PyObject *self, PyObject *args)
{
	unsigned int team;

	if (!PyArg_ParseTuple(args, "I", &team))
	{
		printf("\nError occured inside scriptsdll.disableallgroundvehicles.\n Bad argument(s)?\n");
        return NULL;
	}
	Disable_All_Ground_Vehicles(team);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_disableallflyingvehicles(PyObject *self, PyObject *args)
{
	unsigned int team;

	if (!PyArg_ParseTuple(args, "I", &team))
	{
		printf("\nError occured inside scriptsdll.disableallflyingvehicles.\n Bad argument(s)?\n");
        return NULL;
	}
	Disable_All_Flying_Vehicles(team);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_getteamicon(PyObject *self, PyObject *args)
{
	unsigned int team;
	const char* preset;
	char* icon;

	if (!PyArg_ParseTuple(args, "si", &preset, &team))
	{
		printf("\nError occured inside scriptsdll.getteamicon.\n Bad argument(s)?\n");
		return NULL;
	}
	icon = Get_Team_Icon(preset, team);
	return Py_BuildValue("s", icon);
}

PyObject* scriptsdll_geticon(PyObject *self, PyObject *args)
{
	const char* preset;
	char* icon;

	if (!PyArg_ParseTuple(args, "s", &preset))
	{
		printf("\nError occured inside scriptsdll.geticon.\n Bad argument(s)?\n");
		return NULL;
	}
	icon = Get_Icon(preset);
	return Py_BuildValue("s", icon);
}